function [lap_u_bi,lap_u_lin,grad_p_bi,grad_p_lin,div_u_bi,div_u_lin,force_u_lin]=discrete_operator

global_vars;

[B_h, C_h, M_h] = capital_matrix;

lap_u_bi = sparse(zeros(n_u_node_dof,n_u_node_dof));
lap_u_lin = zeros(n_u_node_dof,1);
for l=1:n_u_node
    if u_node_type(l) == 0 % do the following if it's an interior node
        for j=1:2
            alpha = u_node_val_to_dof(l,j);
            for k=1:n_u_node
                for i=1:2
                    beta = u_node_val_to_dof(k,i);
                    if u_node_type(k) == 0 % if it's an interior node
                        if i == j
                            lap_u_bi(alpha,beta) = - B_h(k,l);
                        end
                    else % if it's a boundary node
                        if i == j
                            lap_u_lin(alpha,1) = lap_u_lin(alpha,1) - u_node_val(k,i)*B_h(k,l);
                        end
                    end
                end
            end
        end
    end
end

grad_p_bi = sparse(zeros(n_u_node_dof,n_p_node_dof));
for l=1:n_u_node
    if u_node_type(l) == 0
        for j=1:2
            alpha = u_node_val_to_dof(l,j);
            for k=1:n_p_node
                kappa = p_node_val_to_dof(k);
                grad_p_bi(alpha,kappa) = - C_h{j}(k,l);
            end
        end
    end
end
grad_p_lin = zeros(n_u_node_dof,1);

div_u_bi = sparse(zeros(n_p_node_dof,n_u_node_dof));
div_u_lin = zeros(n_p_node_dof,1);
for l=1:n_p_node
    sigma = p_node_val_to_dof(l);
    for i=1:2
        for k=1:n_u_node            
            if u_node_type(k) == 0
                beta = u_node_val_to_dof(k,i);
                div_u_bi(sigma,beta) = C_h{i}(l,k);
            else
                div_u_lin(sigma,1) = div_u_lin(sigma,1)+u_node_val(k,i)*C_h{i}(l,k);
            end
        end
    end
end

force_u_lin = zeros(n_u_node_dof,1);
for l=1:n_u_node
    if u_node_type(l) == 0
        for j=1:2
            alpha = u_node_val_to_dof(l,j);
            sum=0;
            for k=1:n_u_node
                sum = sum+u_node_force(k,j)*M_h(k,l);
            end
            force_u_lin(alpha,1) = sum;
        end
    end
end